\version "2.16.0"

\paper {
  %system-system-spacing = 0\mm
  system-system-padding = 5\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  bottom-margin = 3\mm
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Pe bolta cerului senin"
  %subtitle = "Nr. 1"
  composer =  \markup \center-column { "Richard S. Willis" \small 
  "(1819–1900)" }
  poet =  \markup \center-column { "Edmund H. Sears" \small 
  "(1810–1876)" \small "adapt. V. Popovici" }
  %meter = "Adagio"
  tagline=""
}

global = {
  \key bes \major   
  \time 6/8
  \autoBeamOff
  \partial 8
  \set Staff.midiInstrument = "clarinet"
  %#(set-global-staff-size 18
}

womenWords = \lyricmode {
  \set stanza = "1."
  Pe bol -- ta ce -- ru -- lui se -- nin cân -- tări au ră -- su -- nat
  Când în -- ge -- rii du -- ios si lin din har -- fe au cân -- tat:
  “Slă -- vit să fi -- e Dum -- ne -- zeu, şi pa -- ce pe pă -- mânt!”
  As -- cul -- tă-n -- tre -- gul u -- ni -- vers al în -- ge -- ri -- lor cânt.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Şi azi e ce -- rul larg des -- chis, iar în -- ge -- rii în zbor,
  Din stră -- lu -- ciri de ne -- des -- cris, su -- blim ne cân -- tă-n cor.
  Dea -- su -- pra tris -- te -- lor câm -- pii se-a -- plea -- că ce -- rul sfânt
  Să stin -- gă zbu -- ciu -- mul din noi cu-al în -- ge -- ri -- lor cânt.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Căci ia -- tă, cli -- pe -- le gră -- besc spre cea -- sul pro -- fe -- ţit,
  Când vre -- mu -- ri -- le se o -- presc în prag, la ră -- să -- rit
  Când ce -- rul nou se va i -- vi a -- vând un nou pă -- mânt,
  A -- tunci şi oa -- me -- nii vor şti al în -- ge -- ri -- lor cânt. 
}

menWords = \womenWords

sopMusic = \relative c' {   
  f8 |   
  d'4 a8 c[ bes] g8 |   f4 g8 f4 f8 |   
  g[ a] bes bes[ c] d |   
  c4.~ c4 f,8 |   d'4 a8 c[ bes] g8 |   
  f4 g8 f4 f8 |   g4 g8 a[ g] f |   
  bes4.~bes4 d8 |   d4 d,8 d[ e] fis |   
  g4 a8 bes4 d8 |   c[ bes] a g[ a] g |   
  f4.~f4 f8 |   d'4 a8 c[ bes] g8 |   
  f4 g8 f4 f8 |   g4 g8 a[ g] f |   
  bes4.~bes4 \bar "|." 
} 

altMusic = \relative c' {   
  d8 |   
  d4 d8 ees4 ees8 |   d4 ees8 d4 d8 |  
  ees4 ees8 e4 e8 |   f4.~f4 d8 |   
  d4 d8 ees4 ees8 |   d4 ees8 d4 f8 |   
  ees4 ees8 ees4 ees8 |   d4.~ d4 d8 |   
  d4 d8 d[ e] d |   d4 d8 d4 d8 |   
  f4 f8 e4 e8 |   f4.~ f4 ees8 |   
  d4 d8 ees4 ees8 |   d4 ees8 d4 f8 |   
  ees4 ees8 ees4 ees8 |   d4.~ d4 
} 

tenorMusic = \relative c {   
  f8 |   
  f4 fis8 g4 a8 |   bes4 f8 f4 bes8 |   
  bes4 bes8 bes4 bes8 |   a4.~ a4 bes8 |   
  f4 fis8 g4 a8 |   bes4 f8 f4 bes8 |   
  bes4 c8 c[ bes] a |   bes4.~ bes4 d,8 |   
  d4 fis8 fis[ g] a |   g4 fis8 g4 g8 |   
  a[ d] c bes[ c] bes |   a4.~ a4 a8 |   
  f4 fis8 g4 a8 |   bes4 f8 f4 bes8 |   
  bes4 c8 c[ bes] a |   bes4.~ bes4
} 

bassMusic = \relative c {   
  bes8 |   
  bes4 bes8 bes4 bes8 |   
  bes4 a8 bes4 bes8 |   ees[ f] g g4 c,8 |   
  f4.~ f4  bes,8 |   bes4 bes8 bes4 bes8 |   
  bes4 a8 bes4 d8 |   ees4 c8 f4 f8 |   
  bes,4.~ bes4 d8 |   d4 d8 d4 c8 |   
  bes4 d8 g4 bes,8 |   c4 c8 c4 c8 |   
  f4.~ f4 f8 |   bes,4 bes8 bes4 bes8 |   bes4 a8 bes4 d8 |   
  ees4 c8 f4 f8 |   bes,4.~ bes4 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      %\addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 40
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
